#include <algorithm>
#include <vector>
#include <iostream>
#include <stack>
#include <set>

using namespace std;
#define ll long long


	void color_dfs(const vector<vector<int>>& directed_tree, vector<int>& colors, int node, int color)
	{
		stack<pair<int, int>> to_visit;
		to_visit.push({ -1, node });
		colors[node] = color;
		while (!to_visit.empty())
		{
			int parent = to_visit.top().first;
			int node = to_visit.top().second;
			to_visit.pop();
			for (int child : directed_tree[node])
			{
				to_visit.push({ node, child });
				colors[child] = color;
			}
		}
	}

	int count_components_dfs(const vector<vector<int>>& directed_tree, vector<int>& colors)
	{
		stack<vector<int>> to_visit;
		to_visit.push({ -1, 1, -1 }); // parent, node, parent color
		int component_count = 0;
		while (!to_visit.empty())
		{
			int parent = to_visit.top()[0];
			int node = to_visit.top()[1];
			int parent_color = to_visit.top()[2];
			to_visit.pop();
			if (parent_color != colors[node])
				component_count++;

			for (int child : directed_tree[node])
			{
				to_visit.push({ node, child, colors[node] });
			}
		}
		return component_count;
	}


	vector<int> bruteforce(const vector<vector<int>>& tree, vector<int>& colors, const vector<vector<int>> queries)
	{
		// Rebuild the tree into a directed graph
		vector<vector<int>> directed_tree = vector<vector<int>>(tree.size());
		stack<pair<int, int>> to_visit;
		to_visit.push({ -1,1 });
		while (!to_visit.empty())
		{
			int parent = to_visit.top().first;
			int node = to_visit.top().second;
			to_visit.pop();
			for (int neighbor : tree[node])
			{
				if (neighbor != parent)
				{
					to_visit.push({ node, neighbor });
					directed_tree[node].push_back(neighbor);
				}
			}
		}

		vector<int> solution = vector<int>(); solution.reserve(queries.size());
		for (auto query : queries)
		{
			color_dfs(directed_tree, colors, query[0], query[1]);
			solution.push_back(count_components_dfs(directed_tree, colors));
		}

		return solution;
	}


int count_components_dfs_recursive(vector<int>& component_count, const vector<vector<int>>& directed_tree, const vector<int>& colors,
	int parent, int node, int parent_color)
{
	int count = (parent_color != colors[node]);
	for (int child: directed_tree[node])
	{
		count += count_components_dfs_recursive(component_count, directed_tree, colors, node, child, colors[node]);
	}
	component_count[node] = count;
	return count;
}

void make_paths(const vector<vector<int>>& directed_tree, vector<vector<int>>& paths, vector<int>& current_path, int node)
{
	for (int child: directed_tree[node])
	{
		current_path.push_back(child);
		make_paths(directed_tree, paths, current_path, node);
		current_path.pop_back();
	}
	paths[node] = current_path;
}

vector<int> better_solution(const vector<vector<int>>& graph, vector<int>& colors, const vector<vector<int>> queries)
{
	// Rebuild the tree into a directed graph
	vector<int> parents(graph.size(), -1);
	vector<vector<int>> directed_tree = vector<vector<int>>(graph.size());
	stack<pair<int, int>> to_visit;
	to_visit.push({ -1,1 });
	while (!to_visit.empty())
	{
		int parent = to_visit.top().first;
		int node = to_visit.top().second;
		to_visit.pop();
		for (int neighbor : graph[node])
		{
			if (neighbor != parent)
			{
				to_visit.push({ node, neighbor });
				parents[neighbor] = node;
				directed_tree[node].push_back(neighbor);
			}
		}
	}

	vector<int> component_count(graph.size());
	count_components_dfs_recursive(component_count, directed_tree, colors, -1, 1, -1);
	
	vector<int> solution; solution.reserve(queries.size());
	set<int> colored_nodes;
	for (auto query: queries)
	{
		int node = query[0];
		int color = query[1];

		int new_count = 1;
		int temp = node;
		bool any_parent_colored = false;
		while (parents[node] > -1)
		{
			if (colored_nodes.find(parents[node]) != colored_nodes.end())
			{
				component_count[temp] = 0;
				any_parent_colored = true;
				break;
			}
			node = parents[node];
		}
		node = temp;
		if (!any_parent_colored && parents[node] > -1 && colors[parents[node]] == color)
		{
			new_count = 0;
		}

		int difference = new_count - component_count[node];
		component_count[node] = new_count;
		// Propagate the change to parents
		while (parents[node] > -1)
		{
			component_count[parents[node]] += difference;
			node = parents[node];
		}
		node = temp;

		solution.push_back(component_count[1]);
		colored_nodes.insert(node);
	}
	return solution;
}

vector<int> solve_line(const vector<vector<int>>& graph, vector<int>& colors, const vector<vector<int>> queries)
{
	vector<vector<int>> new_queries = vector<vector<int>>(); 
	new_queries.reserve(queries.size() + colors.size());
	for (int i = 1; i < colors.size(); i++)
		new_queries.push_back({ i,colors[i] });
	
	for (size_t i = 0; i < queries.size(); i++)
		new_queries.push_back(queries[i]);
	
	stack<pair<int, int>> s;
	for (size_t i = 0; i < colors.size(); i++)
	{
		auto query = new_queries[i];
		int node = query[0];
		int color = query[1];
		while (!s.empty() && node <= s.top().first)
		{
			s.pop();
		}
		if (s.empty() || color != s.top().second)
		{
			s.push({ query[0],query[1] });
		}
	}

	vector<int> solution = vector<int>();
	solution.reserve(queries.size());
	for (size_t i = colors.size()-1; i < new_queries.size(); i++)
	{
		auto query = new_queries[i];
		int node = query[0];
		int color = query[1];
		while (node <= s.top().first)
		{
			s.pop();
		}
		if (color != s.top().second)
		{
			s.push({ query[0],query[1] });
		}
		solution.push_back(s.size());
	}
	return solution;
}

int main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);

	int node_count, query_count;
	cin >> node_count >> query_count;
	vector<vector<int>> graph(node_count + 1);
	for (size_t i = 0; i < node_count-1; i++)
	{
		int a, b; cin >> a >> b;
		graph[a].push_back(b);
		graph[b].push_back(a);
	}
	vector<int> colors(node_count + 1);
	for (size_t i = 1; i < colors.size(); i++)
		cin >> colors[i];

	vector<vector<int>> queries(query_count, vector<int>(2));
	for (size_t i = 0; i < query_count; i++)
		cin >> queries[i][0] >> queries[i][1];

	bool line_case = true;
	for (size_t i = 2; i < graph.size(); i++)
	{
		if (!(graph[i][0] == i-1))
		{
			line_case = false;
		}
	}
	vector<int> solution;
	if (line_case)
	{
		solution = solve_line(graph, colors, queries);
	}
	else if (node_count <= 1e3 && query_count <= 1e3)
	{
		solution = bruteforce(graph, colors, queries);
	}
	else
	{
		solution = better_solution(graph, colors, queries);
	}

	for(int s: solution)
	{
		cout << s << "\n";
	}

	return 0;
}